var http = require('http')


/* 
GET LEAGUES:
    url: http://18.134.82.247/get-leagues?from=01/14/2021&to=01/16/2021&sport_id=4
    type: GET
    PARAMS: (1) from = '01/14/2021' (mm/dd/yy)
            (2) to = '01/16/2021' (mm/dd/yy)
            (3) sport_id = 4
*/
exports.getLeagues = (req, res) => {
    const { start, end, sportId } = req.body
    var options = {
        host: '18.134.82.247',

        path: `/get-leagues?from=${start}&to=${end}&sport_id=${sportId}`
    };

    callback = function (response) {
        var str = ''
        response.on('data', function (chunk) {
            str += chunk;
            res.send(str)
        })
        response.on('end', function () {
            // res.json({ message: 'Something went wrong!' })

        });
    }
    http.request(options, callback).end()
}


/* 
GET EVENTS:
    url: http://18.134.82.247/get-events?from=01/14/2021&to=01/16/2021&league_id=10790356
    type: GET
    PARAMS: (1) from = '01/14/2021' (mm/dd/yy)
            (2) to = '01/16/2021' (mm/dd/yy)
            (3) league_id = 4
*/
exports.getEvents = (req, res) => {
    const { start, end, leagueId } = req.body
    var options = {
        host: '18.134.82.247',
        path: `/get-events?from=${start}&to=${end}&league_id=${leagueId}`
    };

    callback = function (response) {
        var str = ''
        response.on('data', function (chunk) {
            str += chunk;
            res.send(str)
        })
        response.on('end', function () {
            // res.json({ message: 'Something went wrong!' })

        });
    }
    http.request(options, callback).end()
}

/* 
GET MARKETS:
    url: http://18.134.82.247/get-markets?event_ids=30255898,30255827
    type: GET
    PARAMS: (1) from = '01/14/2021' (mm/dd/yy)
            (2) to = '01/16/2021' (mm/dd/yy)
            (3) event_ids = 30255898,30255827 (COMMA SEPARATED)
*/
exports.getMarket = (req, res) => {
    const { start, end, leagueIds } = req.body
    var options = {
        host: '18.134.82.247',
        path: `/get-markets?from=${start}&to=${end}&event_ids=${leagueIds}`
    };

    callback = function (response) {
        var str = ''
        response.on('data', function (chunk) {
            str += chunk;
            res.send(str)
        })
        response.on('end', function () {
            // res.json({ message: 'Something went wrong!' })

        });
    }
    http.request(options, callback).end()
}

/* 
GET MARKET ODDS:
    url: http://13.126.121.88/get-market-odds?market_ids=1.178528483,1.178528890
    type: GET
    PARAMS: (1) from = '01/14/2021' (mm/dd/yy)
            (2) to = '01/16/2021' (mm/dd/yy)
            (3) market_ids = 1.178528483,1.178528890 (COMMA SEPARATED)
*/
exports.getMarketOdds = (req, res) => {
    const { start, end, marketIds } = req.body
    var options = {
        host: '13.126.121.88',
        path: `/get-market-odds?from=${start}&to=${end}&market_ids==${marketIds}`
    };

    callback = function (response) {
        var str = ''
        response.on('data', function (chunk) {
            str += chunk;
            res.send(str)
        })
        response.on('end', function () {
            // res.json({ message: 'Something went wrong!' })

        });
    }
    http.request(options, callback).end()
}

/* 
GET COUNTRIES:
    url: http://18.134.82.247/get-countries?from=01/14/2021&to=01/16/2021&sport_id=7
    type: GET
    PARAMS: (1) from = '01/14/2021' (mm/dd/yy)
            (2) to = '01/16/2021' (mm/dd/yy)
            (3) sport_id = 4
*/
exports.getCountries = (req, res) => {
    const { start, end, sportId } = req.body
    var options = {
        host: '18.134.82.247',
        path: `/get-countries?from=${start}&to=${end}&sport_id==${sportId}`
    };

    callback = function (response) {
        var str = ''
        response.on('data', function (chunk) {
            str += chunk;
            res.send(str)
        })
        response.on('end', function () {
            // res.json({ message: 'Something went wrong!' })

        });
    }
    http.request(options, callback).end()
}

/* 
GET VENUES:
    url: http://18.134.82.247/get-venues?from=01/28/2021&to=01/30/2021&sport_id=7&country_code=AU
    type: GET
    PARAMS: (1) from = '01/14/2021' (mm/dd/yy)
            (2) to = '01/16/2021' (mm/dd/yy)
            (3) sport_id = 4
            (4) country_code = AU (US,UK)
*/
exports.getVenues = (req, res) => {
    const { start, end, sportId, countryCode } = req.body
    var options = {
        host: '18.134.82.247',
        path: `/get-venues?from=${start}&to=${end}&sport_id==${sportId}&country_code=${countryCode}`
    };

    callback = function (response) {
        var str = ''
        response.on('data', function (chunk) {
            str += chunk;
            res.send(str)
        })
        response.on('end', function () {
            // res.json({ message: 'Something went wrong!' })

        });
    }
    http.request(options, callback).end()
}

/* 
GET VENUE EVENTS:
    url: http://18.134.82.247/get-venue-events?from=01/28/2021&to=01/30/2021&sport_id=7&country_code=AU&venue=Taree
    type: GET
    PARAMS: (1) from = '01/14/2021' (mm/dd/yy)
            (2) to = '01/16/2021' (mm/dd/yy)
            (3) sport_id = 4
            (4) country_code = AU (US,UK)
            (5) venue = Taree (Venue from get venues)
*/
exports.getVenuesEvents = (req, res) => {
    const { start, end, sportId, countryCode, venue } = req.body
    var options = {
        host: '18.134.82.247',
        path: `/get-venue-events?from=${start}&to=${end}&sport_id==${sportId}&country_code=${countryCode}&venue=${venue}`
    };

    callback = function (response) {
        var str = ''
        response.on('data', function (chunk) {
            str += chunk;
            res.send(str)
        })
        response.on('end', function () {
            // res.json({ message: 'Something went wrong!' })

        });
    }
    http.request(options, callback).end()
}

/* 
GET FANCY API:
    url: http://13.126.121.88/api/get-fancies/30359335
    NOTE: where 30359335 = event_id
*/
exports.getFancyApi = (req, res) => {
    const { eventId } = req.body
    var options = {
        host: '13.126.121.88',
        path: `/api/get-fancies/${eventId}`
    };

    callback = function (response) {
        var str = ''
        response.on('data', function (chunk) {
            str += chunk;
            res.send(str)
        })
        response.on('end', function () {
            // res.json({ message: 'Something went wrong!' })

        });
    }
    http.request(options, callback).end()
}
