const express = require('express')
const {
    getLeagues,
    getEvents,
    getMarket,
    getMarketOdds,
    getCountries,
    getVenues,
    getVenuesEvents,
    getFancyApi
} = require('../controllers/admin')
const bodyParser = require('body-parser')
const router = express.Router()
router.use(bodyParser.json())

router.get('/get-leagues', getLeagues)
router.get('/get-events', getEvents)
router.get('/get-markets', getMarket)
router.get('/get-market-odds', getMarketOdds)
router.get('/get-countries', getCountries)
router.get('/get-venues', getVenues)
router.get('/get-venue-events', getVenuesEvents)
router.get('/get-fancies', getFancyApi)

module.exports = router